/* This program creates a PCB footprint for DF40 connectors */

#include <stdio.h>

// Umrechnung mm in 1/100 mil

#define MMTOMILH 100000/25.4

// von hier ab alles in mm

//#define MALE

#define PADDISTANCE 0.4
#define PADWIDTH 0.2
#define PADCLEARANCE 0.3
#define PADSOLDERMASK 0.24
#define PADS 100
#define SIGN_Y -1
#define SIGN_X 1
#define CORNERPADWIDTH 0.35

#ifdef MALE
#define PADLENGTH 0.66
#define ROWDISTANCE 2.71
#define OUTLINE_X_OFFSET 0.96
#define OUTLINE_Y_OFFSET 0.1
#define FILENAME "con100_0.4_male.fp"
#else
#define PADLENGTH 0.7
#define ROWDISTANCE 3.08
#define OUTLINE_X_OFFSET 0.96
#define OUTLINE_Y_OFFSET -0.28
#define OUTLINE_Y_OFFSET_2 0.44
#define FILENAME "con100_0.4_female.fp"
#endif



FILE *filehandle;

int main()
{
  int loop1;
  double pad1_offset_x=0.0;
  double pad1_offset_y=0.0;
  double ymin_row0,ymax_row0,ymin_row1,ymax_row1,xmin;
  double xpos;
  double thickness, clearance,mask;
  ymin_row0 = pad1_offset_y + PADWIDTH/2 * MMTOMILH * SIGN_Y;
  ymax_row0 = ymin_row0 + (PADLENGTH - PADWIDTH) * MMTOMILH * SIGN_Y;
  
  ymin_row1 = ymin_row0 + ROWDISTANCE * MMTOMILH * SIGN_Y;
  ymax_row1 = ymin_row1 + (PADLENGTH - PADWIDTH) * MMTOMILH * SIGN_Y;
  
  xmin = pad1_offset_x + PADWIDTH/2 * MMTOMILH * SIGN_X;
  
  thickness = PADWIDTH * MMTOMILH;
  clearance = PADCLEARANCE * MMTOMILH;
  mask = PADSOLDERMASK * MMTOMILH;
  
  filehandle=fopen(FILENAME,"w");
  
  fprintf(filehandle,"Element[\"\" \"\" \"\" \"\" 14173 110236 0 0 0 100 \"\"]\n(\n");
  for(loop1=0;loop1<PADS/2;loop1++)
  {
    xpos=xmin + ((double) loop1) * PADDISTANCE * MMTOMILH * SIGN_X;
#ifdef MALE
      fprintf(filehandle,"\tPad[%.0f %.0f %.0f %.0f %.0f %.0f %.0f \"%d\" \"%d\" \"square,edge2\"]\n",xpos,ymax_row0,xpos,ymin_row0,thickness,clearance,mask,(loop1+1),(loop1+1));
      fprintf(filehandle,"\tPad[%.0f %.0f %.0f %.0f %.0f %.0f %.0f \"%d\" \"%d\" \"square,edge2\"]\n",xpos,ymax_row1,xpos,ymin_row1,thickness,clearance,mask,(PADS-loop1),(PADS-loop1));
#else     
      fprintf(filehandle,"\tPad[%.0f %.0f %.0f %.0f %.0f %.0f %.0f \"%d\" \"%d\" \"square,edge2\"]\n",xpos,ymax_row0,xpos,ymin_row0,thickness,clearance,mask,(PADS/2-loop1),(PADS/2-loop1));
      fprintf(filehandle,"\tPad[%.0f %.0f %.0f %.0f %.0f %.0f %.0f \"%d\" \"%d\" \"square,edge2\"]\n",xpos,ymax_row1,xpos,ymin_row1,thickness,clearance,mask,(PADS/2+loop1+1),(PADS/2+loop1+1));
#endif
  }
  double corner_x_offset, corner_y_offset,corner_width;
  corner_x_offset = xmin - (PADDISTANCE + (CORNERPADWIDTH - PADWIDTH)/2) * MMTOMILH * SIGN_X;
  corner_y_offset = (CORNERPADWIDTH - PADWIDTH)/2 * MMTOMILH * SIGN_Y;
  fprintf(filehandle,"\tPad[%.0f %.0f %.0f %.0f %.0f %.0f %.0f \"%d\" \"%d\" \"square,edge2\"]\n",corner_x_offset,ymax_row0-corner_y_offset,corner_x_offset,ymin_row0+corner_y_offset,CORNERPADWIDTH*MMTOMILH,0.0,CORNERPADWIDTH*MMTOMILH,(PADS+1),(PADS+1));
  fprintf(filehandle,"\tPad[%.0f %.0f %.0f %.0f %.0f %.0f %.0f \"%d\" \"%d\" \"square,edge2\"]\n",corner_x_offset,ymax_row1-corner_y_offset,corner_x_offset,ymin_row1+corner_y_offset,CORNERPADWIDTH*MMTOMILH,0.0,CORNERPADWIDTH*MMTOMILH,(PADS+2),(PADS+2));

  corner_x_offset = xmin + ((double) PADS/2 -1) * PADDISTANCE * MMTOMILH * SIGN_X + (PADDISTANCE + (CORNERPADWIDTH - PADWIDTH)/2) * MMTOMILH * SIGN_X;
  fprintf(filehandle,"\tPad[%.0f %.0f %.0f %.0f %.0f %.0f %.0f \"%d\" \"%d\" \"square,edge2\"]\n",corner_x_offset,ymax_row0-corner_y_offset,corner_x_offset,ymin_row0+corner_y_offset,CORNERPADWIDTH*MMTOMILH,0.0,CORNERPADWIDTH*MMTOMILH,(PADS+3),(PADS+3));
  fprintf(filehandle,"\tPad[%.0f %.0f %.0f %.0f %.0f %.0f %.0f \"%d\" \"%d\" \"square,edge2\"]\n",corner_x_offset,ymax_row1-corner_y_offset,corner_x_offset,ymin_row1+corner_y_offset,CORNERPADWIDTH*MMTOMILH,0.0,CORNERPADWIDTH*MMTOMILH,(PADS+4),(PADS+4));
  double outline_x_min,outline_x_max,outline_y_min,outline_y_max;
  outline_x_min = xmin - OUTLINE_X_OFFSET * MMTOMILH * SIGN_X + thickness * SIGN_X;
  outline_x_max = xmin + ((double) PADS/2 -1) * PADDISTANCE * MMTOMILH * SIGN_X + OUTLINE_X_OFFSET * MMTOMILH * SIGN_X - thickness * SIGN_X;
  outline_y_min = ymax_row0 + OUTLINE_Y_OFFSET * MMTOMILH * SIGN_Y + thickness * SIGN_Y;
  outline_y_max = ymin_row1 - OUTLINE_Y_OFFSET * MMTOMILH * SIGN_Y - thickness * SIGN_Y;
  fprintf(filehandle,"ElementLine [%.0f %.0f %.0f %.0f %.0f]\n",outline_x_min,outline_y_min,outline_x_max,outline_y_min,thickness);
  fprintf(filehandle,"ElementLine [%.0f %.0f %.0f %.0f %.0f]\n",outline_x_max,outline_y_min,outline_x_max,outline_y_max,thickness);
  fprintf(filehandle,"ElementLine [%.0f %.0f %.0f %.0f %.0f]\n",outline_x_min,outline_y_max,outline_x_max,outline_y_max,thickness);
  fprintf(filehandle,"ElementLine [%.0f %.0f %.0f %.0f %.0f]\n",outline_x_min,outline_y_min,outline_x_min,outline_y_max,thickness);
#ifndef MALE
  outline_y_min = ymax_row0 + OUTLINE_Y_OFFSET_2 * MMTOMILH * SIGN_Y + thickness * SIGN_Y;
  outline_y_max = ymin_row1 - OUTLINE_Y_OFFSET_2 * MMTOMILH * SIGN_Y - thickness * SIGN_Y;
  fprintf(filehandle,"ElementLine [%.0f %.0f %.0f %.0f %.0f]\n",outline_x_min,outline_y_min,outline_x_max,outline_y_min,thickness);
  fprintf(filehandle,"ElementLine [%.0f %.0f %.0f %.0f %.0f]\n",outline_x_min,outline_y_max,outline_x_max,outline_y_max,thickness);
#endif  
  fprintf(filehandle,"\t)\n");
  fclose(filehandle);
  return 0;
}
